#pragma once

#include <infra/proto_logger/api/api.pb.h>
#include <infra/proto_logger/api/internal.pb.h>

#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

namespace NProtoLogger {
    class IApi {
    public:
        virtual ~IApi() = default;

        virtual void Ping(NInfra::TRequestPtr<NApi::TReqPing>, NInfra::TReplyPtr<NApi::TRspPing>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Shutdown(NInfra::TRequestPtr<NApi::TReqShutdown>, NInfra::TReplyPtr<NApi::TRspShutdown>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog>, NInfra::TReplyPtr<NApi::TRspReopenLog>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Write2Log(NInfra::TRequestPtr<NApi::TReqWrite2LogQuasar>, NInfra::TReplyPtr<NApi::TRspWrite2LogQuasar>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void WriteBatch2Log(NInfra::TRequestPtr<TVector<NApi::TReqWrite2LogQuasar>>, NInfra::TReplyPtr<TVector<NApi::TRspWrite2LogQuasar>>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Write2Log(NInfra::TRequestPtr<NApi::TReqWriteMetrics2LogQuasar>, NInfra::TReplyPtr<NApi::TRspWrite2LogQuasar>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void WriteBatch2Log(NInfra::TRequestPtr<TVector<NApi::TReqWriteMetrics2LogQuasar>>, NInfra::TReplyPtr<TVector<NApi::TRspWrite2LogQuasar>>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Write2Log(NInfra::TRequestPtr<NApi::TReqCardShownLog>, NInfra::TReplyPtr<NApi::TRspCardShownLog>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void WriteBatch2Log(NInfra::TRequestPtr<TVector<NApi::TReqCardShownLog>>, NInfra::TReplyPtr<TVector<NApi::TRspCardShownLog>>) {
            ythrow NInfra::TNotImplementedError();
        }
    };
}
