import logging

import gevent


class Controller(object):
    sleep_seconds = 10

    def loop_iteration(self):
        raise NotImplementedError()

    def loop(self):
        while True:
            try:
                self.loop_iteration()
            except (RuntimeError, IOError):
                logging.exception('Exception')
            except (KeyboardInterrupt, Exception):
                logging.exception('Exception, exiting')
                exit(1)
            finally:
                gevent.sleep(self.sleep_seconds)

    @classmethod
    def signals(cls):
        return []
