import json
import logging

import flask
import gevent
import gevent.pywsgi


class MainCtrl(object):
    def __init__(
        self,
        cluster_name,
        controllers,
    ):
        self._cluster_name = cluster_name
        self._controllers = controllers

    def loop(self):
        greenlets = []
        for ctrl in self._controllers:
            greenlets.append(gevent.spawn(ctrl.loop))
        gevent.wait(greenlets)

    def _signals(self):
        def _add_prj(signal_and_value):
            signal_name, value = signal_and_value
            return ['prj={};{}'.format(self._cluster_name, signal_name), value]

        signals = []
        for ctrl in self._controllers:
            signals += map(_add_prj, ctrl.signals())
        return signals

    def _yasm_signals(self):
        return flask.Response(json.dumps(self._signals()))

    def spawn_yasm(self, port):
        app = flask.Flask(__name__)
        app.add_url_rule('/yasm/signals', 'yasm', view_func=self._yasm_signals)
        gevent.spawn(gevent.pywsgi.WSGIServer(('::', port), app).serve_forever)


_log = logging.getLogger(__name__)
