import os
import socket
import logging

import requests

import ctrl
import utils


class MemoryController(ctrl.Controller):
    sleep_seconds = 120

    def __init__(
        self,
        container_name,
        cluster_name,
        configs_url,
    ):
        self._container_name = container_name
        self._cluster_name = cluster_name
        self._configs_url = configs_url
        self._memory_guarantee = None

    def loop_iteration(self):
        fqdn = os.environ.get('NODE_NAME') or socket.getfqdn()
        url = os.path.join(self._configs_url, 'configs', fqdn)
        new_limit = requests.get(
            url,
            params={'cluster': self._cluster_name, 'type': 'static'}
        ).json()['limits']['mem']['max']
        with utils.porto_connect() as conn:
            if new_limit != self._memory_guarantee:
                conn.SetProperty(self._container_name, 'memory_limit', bytes(new_limit))
                conn.SetProperty(self._container_name, 'memory_guarantee', bytes(new_limit))
                logging.info('set memory %s -> %s', self._memory_guarantee, new_limit)
                self._memory_guarantee = new_limit

    def signals(self):
        return [
            ['yt_memory_guarantee_ammv', self._memory_guarantee],
        ]
