import os.path
import sys
import logging
import requests


def exit_success():
    sys.exit(0)


def exit_fail():
    sys.exit(32)


def exit_error():
    sys.exit(1)


def main(port, config_path, changes):
    try:
        logging.debug('changes: %s', changes)
        logging.debug('ls: %s', os.listdir(os.getcwd()))
        assert os.path.basename(config_path) not in changes
        data = requests.post('http://localhost:{}/recalc_md5'.format(port), timeout=20).json()
        if data['ok']:
            exit_success()
    except Exception as ex:
        logging.exception(ex)
    exit_fail()
