import logging
import gevent

from utils.online import OnlineState
from utils.names import hostname


class Reporter(OnlineState):
    _logger = logging.getLogger('Reporter')
    _hostname = hostname()

    def __init__(self, url, rate, monitor, configs):
        super(Reporter, self).__init__()
        self._url = url
        self._sleep_time = rate
        self.monitor = monitor
        self.configs = configs

    def report(self, data):
        self._post(self.url('report'), data)

    def extend_one(self, doc, config):
        doc['host'] = self._hostname
        doc['cluster'] = config.cluster
        return doc

    def check_one(self, cont_conf):
        if cont_conf not in self.monitor:
            doc = self.monitor.default_json(cont_conf)
        else:
            doc = self.monitor[cont_conf].json()
        return self.extend_one(doc, cont_conf)

    def check_all(self):
        res = []
        for container in self.configs:
            res.append(self.check_one(container))
        return res

    def _run(self):
        while True:
            try:
                report = self.check_all()
                self.report({'containers': report})
            except Exception as ex:
                logging.exception(ex)
            finally:
                gevent.sleep(self._sleep_time)
