import sys
import socket
import logging
import requests

from global_config import load_conf, parse_limits_conf, parse_api_conf


def exit_success():
    sys.exit(0)


def exit_fail():
    sys.exit(32)


def exit_error():
    sys.exit(1)


def check_enough_resources(api, limits):
    request = '{}/configs/{}?type={}'.format(api.url, socket.getfqdn(), api.type)
    data = requests.get(request).json()
    if data == {}:
        return False
    data = data.popitem()[1]['limits']
    if float(data['cpu']['min']) < float(limits.cpu.destroy_on):
        return False
    if float(data['mem']['min']) < float(limits.mem.destroy_on):
        return False
    return True


def check(port, api_conf, limits_conf):
    if not check_enough_resources(api_conf, limits_conf):
        exit_success()
    data = requests.get('http://localhost:{}/started_ok'.format(port), timeout=20).json()
    if data['ok']:
        exit_success()
    else:
        exit_fail()


def main(port, config_path):
    try:
        data = load_conf(config_path)
        check(port, parse_api_conf(data), parse_limits_conf(data))
    except Exception as ex:
        logging.exception(ex)
        exit_fail()

    exit_success()
