import math
import time
import multiprocessing


class MovingAverage(object):
    def __init__(self, coefficient, value=0.0):
        self.coefficient = float(coefficient)
        self.value = float(value)

    def push(self, value):
        self.value = self.coefficient * value + (1 - self.coefficient) * self.value
        return self.value


class CpuUsage(object):
    def __init__(self, probe_interval, window_size):
        super(CpuUsage, self).__init__()
        self._prev = None
        self._last_upd = time.time()
        self._value = MovingAverage(1 - math.exp(-probe_interval / float(window_size)))

    @property
    def value(self):
        """[0, 100 * NCores] percents"""
        return self._value.value

    def update(self, ns):
        now = time.time()
        if self._prev and ns > self._prev:
            self._value.push(100.0 * (ns - self._prev) / (now - self._last_upd) / 1e9)
        self._prev = ns
        self._last_upd = now


CPU_MIN_DELTA = 50


def cmp_cpu(value1, value2):
    res = value1 - value2
    if abs(res) <= CPU_MIN_DELTA:
        return 0
    return res


def cpu_count():
    return multiprocessing.cpu_count()


def cpu_total():
    return cpu_count() * 100.0
