import socket


def is_psi(namespace, name):
    if '/' not in name:
        return False
    name = name.split('/')
    return name[0] == namespace and len(name) == 2


def porto_name_to_name(namespace, porto_name):
    return porto_name.replace('{}/'.format(namespace), '')


def name_to_porto_name(namespace, name):
    return '{}/{}'.format(namespace, name)


def dns_to_port(dns_name):
    return int(dns_name.partition('.vm')[0].split('-')[-1])


def hostname():
    return socket.getfqdn()
