import requests
import gevent
import logging
import json
from datetime import datetime as dt


class OnlineState(gevent.Greenlet):
    _url = 'http://psi.yandex-team.ru'
    _logger = logging.getLogger('online')
    _error = None
    _last_upd = dt.min

    _sleep_time = 15
    _timeout = 10

    def url(self, *args, **kwargs):
        tail = '/{}' * len(args)
        tail = tail.format(*args)
        extra = ''
        if kwargs:
            for key, value in kwargs.items():
                extra += '&{}={}'.format(key, value)
            extra = extra[1:]
        res = self._url + tail + '?' + extra
        return res

    def _after_request(self, response):
        if not response.ok:
            self._error = response
            self._logger.info('since upd {}'.format(self.since_upd()))
        else:
            self._last_upd = dt.now()
            self._error = None
        return response

    def _get(self, url):
        try:
            self._logger.debug('get request')
            res = requests.get(url, timeout=self._timeout)
            self._logger.debug('get request done')
        except requests.RequestException as ex:
            self._logger.exception(ex)
            res = requests.Response()
            res.status_code = 500
        return self._after_request(res)

    def _post(self, url, data=None):
        try:
            res = requests.post(url, data=None if data is None else json.dumps(data), timeout=self._timeout)
        except requests.RequestException as ex:
            self._logger.exception(ex)
            res = requests.Response()
            res.status_code = 500
        return self._after_request(res)

    def since_upd(self, none_if_not_yet=False):
        if none_if_not_yet and self._last_upd == dt.min:
            return None
        return (dt.now() - self._last_upd).total_seconds()
