import subprocess as sp
import os


def rb_name(resource_id):
    data = sp.Popen(['sky', 'files', resource_id], stdout=sp.PIPE).communicate()[0]
    data = eval(data)
    return data[0]['name']


def _sky_get_to_dir(resource_id, path):
    if not os.path.exists(path):
        os.makedirs(path)
    sp.Popen(['sky', 'get', '-uw', resource_id], cwd=path).communicate()
    return path


def sky_get(resource_id, to_path, many=False, new_name=None):
    _sky_get_to_dir(resource_id, to_path)
    if many:
        return to_path
    else:
        old_name = rb_name(resource_id)
        if new_name:
            sp.Popen(['mv', '{}/{}'.format(to_path, old_name), '{}/{}'.format(to_path, new_name)]).communicate()
            return '{}/{}'.format(to_path, new_name)
        else:
            return '{}/{}'.format(to_path, old_name)
