import abc
import logging


class ContainerMode:
    os = 'os'
    app = 'app'


class AbsContainer(object):
    __metaclass__ = abc.ABCMeta

    @abc.abstractproperty
    def porto_name(self):
        pass

    def __hash__(self):
        return hash(self.porto_name)


class AbsPsi(AbsContainer):
    @abc.abstractproperty
    def psi_configuration(self):
        pass

    @abc.abstractproperty
    def name(self):
        pass

    @abc.abstractproperty
    def mode(self):
        pass


class AbsPsiVM(AbsPsi):
    @abc.abstractproperty
    def dns_name(self):
        pass

    @property
    def mode(self):
        return ContainerMode.os

    def __eq__(self, other):
        _logger = logging.getLogger('__eq__')
        _logger.debug([self.__class__, other.__class__, isinstance(other, AbsPsiVM)])
        if self.mode != other.mode:
            return False
        _logger.debug([self.name, self.dns_name, self.porto_name, self.psi_configuration])
        _logger.debug([other.name, other.dns_name, other.porto_name, other.psi_configuration])
        return all([
            self.name == other.name,
            self.dns_name == other.dns_name,
            self.porto_name == other.porto_name,
            self.psi_configuration == other.psi_configuration
        ])

    def __ne__(self, other):
        _logger = logging.getLogger('__neq__')
        _logger.debug([self.__class__, other.__class__, self.mode, other.mode])
        if self.mode != other.mode:
            return True
        if self.psi_configuration is None or other.psi_configuration is None:
            return False
        return not self.__eq__(other)


class AbsPsiApp(AbsPsi):
    @abc.abstractproperty
    def command(self):
        pass

    @property
    def mode(self):
        return ContainerMode.app

    def __eq__(self, other):
        _logger = logging.getLogger('__eq__')
        _logger.debug([self.__class__, other.__class__, isinstance(other, AbsPsiApp)])
        if self.mode != other.mode:
            return False
        _logger.debug([self.name, self.porto_name, self.psi_configuration])
        _logger.debug([other.name, other.porto_name, other.psi_configuration])
        return all([
            self.name == other.name,
            self.porto_name == other.porto_name,
            self.psi_configuration == other.psi_configuration,
            bytes(self.command).strip() == bytes(other.command).strip()
        ])

    def __ne__(self, other):
        _logger = logging.getLogger('__neq__')
        _logger.debug([self.__class__, other.__class__, self.mode, other.mode])
        if self.mode != other.mode:
            return True
        if self.psi_configuration is None or other.psi_configuration is None:
            return False
        return not self.__eq__(other)
