import json

import retry

from utils import porto_utils as pu
from utils import network


def check(cluster, porto_name):
    for check_ in CUSTOM_CHECKS.get(cluster, []):
        status = check_(porto_name)
        if status is not None:
            return status
    return None


def check_xcalc_bad_init(porto_name):
    host = pu.get_hostname(porto_name)
    try:
        status = retry.retry(tries=3, delay=5)(network.read_tcp)(host, 8000)
        status = json.loads(status)
        bad_init = (status['badinit'] == 1)
    except (IOError, ValueError):
        bad_init = True

    if bad_init and pu.get_time(porto_name) > 10 * 60:
        return 'bad_init'
    return None


CUSTOM_CHECKS = {
    'xcalc': [
        check_xcalc_bad_init,
    ]
}
