IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:kernel)

SET(QEMU_VERSION 4.2.0)
SET(QEMU_RESOURCE 1362234037)
SET(QEMU_SRC qemu-${QEMU_VERSION}.tar.xz)
SET(QEMU_OUT qemu.tar.gz)
SET(QEMU_BUILD_ENV infra/qemu/build_env/release)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)


PEERDIR(
    ${QEMU_BIN_ROOT}
    ${QEMU_BUILD_ENV}/vm-image
)

FROM_SANDBOX(
    FILE ${QEMU_RESOURCE}
    OUT ${QEMU_SRC}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} -I ${ARCADIA_BUILD_ROOT}/${QEMU_BUILD_ENV}/vm-image/rootfs.img --vcpu 8 --mem 8G  --
                   build-qemu.py build ${QEMU_SRC} ${QEMU_OUT}
    CWD ${BINDIR}
    IN build-qemu.py
       ${QEMU_SRC}
       ${ARCADIA_BUILD_ROOT}/${QEMU_BIN_APP}
       ${ARCADIA_BUILD_ROOT}/${QEMU_BUILD_ENV}/vm-image/rootfs.img

    OUT_NOAUTO ${QEMU_OUT}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
