#!/bin/sh

BASE_IMG=$PWD/../kernel/tools/qemu/images/testvm/ubuntu-18.04-x86_64/rootfs.img
DISK_IMG=disk.img

test -e $DISK_IMG || qemu-img create -f qcow2 -b $BASE_IMG $DISK_IMG

qemu-system-x86_64 \
-serial stdio \
-monitor none \
-nographic \
-accel kvm \
-cpu host \
-m 512 \
-netdev user,id=vnet,hostfwd=tcp::5022-:22 \
-device virtio-net-pci,netdev=vnet \
-drive file=$DISK_IMG,if=virtio,cache=none
