from __future__ import print_function
import uuid

from qemutool.guest.basevm import BaseVM


class QAVM(BaseVM):
    name = "testvm"

    @staticmethod
    def gen_name(id_len=8):
        return "qavm-{}.qemu".format(str(uuid.uuid4())[0:id_len])

    def __init__(self, vcpus=2, mem="4G", name=None, **kwargs):
        super(QAVM, self).__init__(vcpus=vcpus, mem=mem, **kwargs)

        self.set_qa_auth()
        if name:
            self.name = name
        else:
            self.name = QAVM.gen_name()
        self._args += ['-smbios', 'type=1,serial=ds=nocloud;i={};l={}'.format(self. name, self.name)]

        self.cloud_init = {
            'meta-data': {
            },
            'user-data': {
                'disable_root': False,
                'apt': {
                    'preserve_sources_list': True,
                },
                'runcmd': ["echo 127.0.0.1 " + self.name + " >> /etc/hosts",
                           "echo ::1 " + self.name + " >> /etc/hosts"],
                'users': [
                    {
                        'name': 'root',
                        'lock_passwd': False,
                        'ssh_pwauth': True,
                        'ssh_authorized_keys': [
                            self.ssh_pub_key
                        ],
                    },
                    {
                        'name': 'qemu',
                        'passwd': '$6$KpYsdCFY5wL3a$ZW/QU0/tWFEkiW3F/jvv1JqfwITs.FPBPolOEkyCNvTDUo6FT1hELjqr4wGopEG.lJOv1OFiRXo9AEdp9zhrl0',  # qemupass
                        'lock_passwd': False,
                        'ssh_pwauth': True,
                        'ssh_authorized_keys': [
                            self.ssh_pub_key
                        ],
                        'sudo': [
                            'ALL=(ALL) NOPASSWD:ALL'
                        ],
                        'shell': '/bin/bash',
                    },
                ],
            }
        }
