#!/bin/bash

# Create and mount filesystem

set -o errexit
set -o nounset
set -o pipefail
set -o xtrace

img=testfs.img
m="mnt"

truncate -s 512M $img
mkfs.ext4 $img
mkdir -p $m

mount $img $m -oloop,noload,nobarrier
echo hello world > $m/test.txt

umount $m
rmdir $m

