#!/bin/bash
set -e

if [ "$#" -ne "1" ]; then
	echo "Usage: $0 <qavm-id>"
	exit 1
fi

qavmid="$1"
port=$(ps -aux | grep ssh | grep "qavm-${qavmid}.qemu" | sed "s/.*-p \([0-9]*\).*/\1/" | uniq)

if [ -z "$port" ]; then
	echo "Failed to find qavm-${qavmid}.qemu instance"
	exit 1
fi

re='^[0-9]+$'
if ! [[ $port =~ $re ]]; then
	echo "Failed to parse port number"
	exit 1
fi

echo "Attach into qavm-${qavmid}.qemu using port ${port}"

ssh -F /dev/null -q -t \
	-o ConnectTimeout=60 \
	-o ServerAliveInterval=20 \
	-o ServerAliveCountMax=3 \
	-o StrictHostKeyChecking=no \
	-o UserKnownHostsFile=/dev/null \
	-p ${port} \
	-i ${HOME}/.ya/vmexec/qavm-${qavmid}.qemu/id_rsa \
	-l root 127.0.0.1
