#!/bin/bash

set -xe 

if [ ! -d $ARC_ROOT ]
then
    echo "ARC_ROOT variable required"
    exit 1
fi

vmexec=$ARC_ROOT/infra/qemu/vmexec/vmexec
initrd_builder=$ARC_ROOT/infra/kernel/tools/kvm_kernel/builder/builder
rootfs=$ARC_ROOT/infra/environments/rtc-xenial/release/vm-layer-nk/layer.squashfs
ya make $(dirname $vmexec) $(dirname $initrd_builder) $(dirname $rootfs)

kernelrelease=$(make kernelrelease)
mod_path=tar-install


test -d $mod_path && rm -rf $mod_path
mkdir -p $mod_path/boot
time make -j$(nproc)
time make -j$(nproc)  INSTALL_MOD_PATH=$mod_path  INSTALL_PATH=$mod_path/boot modules_install install 

$initrd_builder  build  -q -m $mod_path --initrd-only $kernelrelease $mod_path/boot > /dev/null
$vmexec  -w / --kernel $mod_path/boot/vmlinuz-$kernelrelease --initrd $mod_path/boot/initrd.img --modules $mod_path  -I $rootfs $@

