#!/bin/bash

set -e 

die() {
    echo $1
    exit 1
}

krel=$1
krel_majmin=$(echo $krel | cut -d '.' -f 1-2)
vmexec=$($ARC_ROOT/ya tool vmexec --print-path)
#vmexec=$ARC_ROOT/infra/qemu/vmexec/vmexec
test -z "$krel_majmin" && die "Usage: $0 kernel-release [vmexec options]"

shift

krel_dir=$ARC_ROOT/infra/kernel/releases/$krel_majmin/$krel
rootfs=$ARC_ROOT/infra/environments/rtc-focal/release/vm-layer-nk/layer.squashfs

test -z "$ARC_ROOT" && die "ARC_ROOT variable required"
test -d "$krel_dir" || die "kernel release dir $krel_dir not exists"

# prepare resources
$ARC_ROOT/ya make $krel_dir $(dirname $rootfs)

$vmexec -w / -K $krel_dir -I  $rootfs $@


