#!/bin/bash

set -xe 

if [ ! -d $ARC_ROOT ]
then
    echo "ARC_ROOT variable required"
    exit 1
fi

if [ "$#" -lt "1" ]; then
    echo "Usage: $0 <tarball-path> [...]"
    exit 1
fi

tarball="$1"
shift

if [ ! -f "$tarball" ]; then
    echo "File $tarball does not exists"
    exit 1
fi

vmexec=$ARC_ROOT/infra/qemu/vmexec/vmexec
initrd_builder=$ARC_ROOT/infra/kernel/tools/kvm_kernel/builder/builder
rootfs=$ARC_ROOT/infra/environments/rtc-xenial/release/vm-layer-nk/layer.squashfs
ya make $(dirname $vmexec) $(dirname $initrd_builder) $(dirname $rootfs)

mod_path=$(mktemp -d)
tar xf $tarball --directory $mod_path

vmlinuz=$(basename $(ls -1 $mod_path/boot/vmlinuz-*))
kernelrelease=$(echo $vmlinuz | sed -e "s/^vmlinuz-//")

$initrd_builder  build  -q -m $mod_path --initrd-only $kernelrelease $mod_path/boot > /dev/null
$vmexec  -w / --kernel $mod_path/boot/vmlinuz-$kernelrelease --initrd $mod_path/boot/initrd.img --modules $mod_path  -I $rootfs $@

rm -rf "$mod_path"
