#!env python

import ConfigParser
import os


cfg = """
---
qloud_check:
  - name: qloud_routers_yasm
    tags:
      - qloud_routers_yasm
    notifications:
      - template: on_status_change
        status: [WARN]
        method: [telegram]
        login: [qloud-ops]
      - template: on_status_change
        status: [CRIT]
        method: [sms]
        login: [kozhapenko, xgen, bgleb, terry]

default_check:
  aggregator: logic_or
  flap:
    stable: 30
    critical: 60
"""


def create_qloud_checks(config):
    conf = ConfigParser.RawConfigParser()
    path = os.path.join(os.getcwd(), '../in/qloud_alerts.ini')
    if os.path.exists(path):
        conf.read(path)
    else:
        raise ConfigParser.Error

    sects = []
    for sec in conf.sections():
        if sec.startswith('qloud.QLOUD'):
            sects.append(sec)
        else:
            continue

    checks = []
    for el in config:
        for service in sects:
            n = {
                "host": el["host"],
                "alert_method": el.get("alert_method", []),
                "responsible": el.get("responsible", []),
                "aggregator": el.get("aggregator", "logic_or"),
                "refresh_time": el.get("refresh_time", 5),
                "service": service,
                "children": "yasm_alert:" + service,
                "tags": el.get("tags", []),
                "notifications": el.get("notifications", [])
            }
            checks.append(n)

    return checks


class FilterModule(object):

    def filters(self):
        return {
            'create_qloud_checks': create_qloud_checks
        }
