#!/bin/bash

set -e

usage() {
    echo "Usage: $0 <IMAGE-NAME> <BOOTSTRAP-RESOURCE>"
    exit 1
}

[[ -z $1 || -z $2 ]] && usage

set -u

IMAGE=$1
BOOTSTRAP=$2
VERSION=$(date +%Y%m%d)
IMAGE_URL="registry.yandex.net/platform-base-images/${IMAGE}:${VERSION}"
IMAGE_LATEST="registry.yandex.net/platform-base-images/${IMAGE}:latest"

[[ -d $IMAGE ]] || (echo "No image named $IMAGE exists" && exit 2)

BOOTSTRAP_CACHE="0"
if [[ $BOOTSTRAP == "sbr:"* ]]; then
    res=$(echo $BOOTSTRAP | cut -f2 -d':')
    BOOTSTRAP="https://proxy.sandbox.yandex-team.ru/${res}"
    BOOTSTRAP_FILE="bootstrap${res}.tgz"
    BOOTSTRAP_CACHE="1"
elif [[ $BOOTSTRAP == "http"* ]]; then
    BOOTSTRAP_FILE="bootstrap.tgz"
else
    echo "Unknown bootstrap resource scheme: ${BOOTSTRAP}"
fi

if [[ ! -f $BOOTSTRAP_FILE || $BOOTSTRAP_CACHE == "0" ]]; then
    curl -o $BOOTSTRAP_FILE $BOOTSTRAP
    tar -c -z -f tmp.tgz @$BOOTSTRAP_FILE
    mv tmp.tgz $BOOTSTRAP_FILE
fi

docker import $BOOTSTRAP_FILE porto-bootstrap

cd $IMAGE
cp ../provision_base.sh .
tar -c -z -f provision.tgz provision_base.sh provision.sh
rm provision_base.sh

docker build -t $IMAGE_URL .
docker push $IMAGE_URL
IMAGE_DIGEST=$(docker inspect -f '{{.Id}}' $IMAGE_URL)
docker tag $IMAGE_DIGEST $IMAGE_LATEST
docker push $IMAGE_LATEST
cd ..

