#!/bin/bash

set -e

cleanup() {
    apt-get remove -y ntp ntpdate || true

    rm /etc/apt/sources.list.d/provision*.list
    apt-get update -qq
    apt-get clean
    find /var/cache/apt/archives -iname '*.deb' -delete
    find /var/lib/apt/lists -type f -delete
    find /var/cache/apt -iname '*.bin' -delete

    if [ -f /lib/init/fstab ]; then
        sed -e 's/^/#/g' -i /lib/init/fstab
    fi
    if [ -f /etc/init/procps.conf ]; then
        sed -e 's#\(| sysctl -e -p -$\)#\1 || true#' -i /etc/init/procps.conf
    fi
    cp -a /dev/null /dev/.devfsd

    ln -sf /proc/self/mounts /etc/mtab

    tee /etc/init/power-status-changed.conf <<EOF
start on power-status-changed
exec /sbin/shutdown -h now
EOF

    find /var/log -iname '*.gz' -delete
    find /var/log -iname '*.1' -delete
    find /var/log -type f -print0 | xargs -0 -t tee < /dev/null

    > /root/.bash_history
}

postconfig() {
    echo "nothing to do in postconfig"
}

provision() {
    export DEBIAN_FRONTEND="noninteractive"
    export FORCE_YES="--allow-unauthenticated --assume-yes"
    export APT_INSTALL="apt-get install --yes --no-install-recommends ${FORCE_YES} ${APT_VER_11:+ --allow-change-held-packages --allow-remove-essential --allow-downgrades}"

    mkdir -p /etc/apt/sources.list.d
    repo > /etc/apt/sources.list.d/provision.list

    apt-mark hold mount || true
    apt-mark hold mountall || true
    apt-mark hold upstart || true
    apt-mark hold initscripts || true

    apt-get update -qq
    apt-get -f install --yes $FORCE_YES
    DEBIAN_FRONTEND=noninteractive apt-get upgrade --yes $FORCE_YES
    $APT_INSTALL language-pack-en yandex-archive-keyring $(additional_packages)
    update-locale LANG=en_US.UTF-8

    cleanup
    postconfig
}
