#!/usr/bin/python

import datetime
import json
import os
import sys
import subprocess
import time
import urllib2
import traceback

installation = os.getenv('QLOUD_INSTALLATION')
domain = 'qloud.yandex-team.ru'
if installation == 'external':
    domain = 'qloud-ext.yandex-team.ru'


def writefile(p, data, chmod):
    tmp = p + '_tmp'
    with open(tmp, 'w') as f:
        f.write(data)

    os.chmod(tmp, chmod)
    os.rename(tmp, p)


def makedirs(p, chmod):
    try:
        os.makedirs(p)
    except OSError:
        pass

    os.chmod(p, chmod)


def fetch_keys():
    url = 'https://{}/api/restricted/ssh-keys/root'.format(domain)
    data = "\n".join(json.load(urllib2.urlopen(url)))

    ssh_dir = '/root/.ssh'

    makedirs(ssh_dir, 0700)
    writefile(os.path.join(ssh_dir, 'authorized_keys'), data, 0600)


def ensure_skynet_running():
    subprocess.check_call(['/skynet/startup/up.py', 'start'])


while True:
    print '=====', datetime.datetime.now(), 'up.py here'

    def try_to_run(f):
        try:
            f()
        except Exception:
            print>>sys.stderr, '%s error in %s:' % (datetime.datetime.now(), f.__name__)
            traceback.print_exc()

    try_to_run(fetch_keys)
    try_to_run(ensure_skynet_running)

    time.sleep(60)
