#!/bin/bash

set -e

sshkeys() {
    DOMAIN="qloud"
    if [[ "$QLOUD_INSTALLATION" == "external" ]]; then
        DOMAIN="qloud-ext"
    fi
    URL="https://${DOMAIN}.yandex-team.ru/api/restricted/ssh-keys/root"

    mkdir -p /root/.ssh
    chmod 700 /root/.ssh
    (
        curl $URL | python -c 'import json, sys; print "\n".join(json.load(sys.stdin))'
    ) >/root/.ssh/authorized_keys
    chmod 600 /root/.ssh/authorized_keys
}

while true; do
    sshkeys
    /skynet/startup/up.py start
    sleep 60
done
