package ru.yandex.qloud.kikimr.jobs.qloud;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.qe.qloud.api.environment.EnvironmentLocator;

/**
 * @author violin
 */
public class LoggerSettings {
    private final EnvironmentLocator environmentLocator;
    private final int esIndexTtl;
    private final boolean esShipAccessLog;

    @JsonCreator
    public LoggerSettings(
            @JsonProperty("environmentLocator") final SimpleEnvironmentLocator environmentLocator,
            @JsonProperty("esIndexTtl") final int esIndexTtl,
            @JsonProperty("esShipAccessLog") final boolean esShipAccessLog
    ) {
        this.environmentLocator = environmentLocator;
        this.esIndexTtl = esIndexTtl;
        this.esShipAccessLog = esShipAccessLog;
    }

    public EnvironmentLocator getEnvironmentLocator() {
        return environmentLocator;
    }

    public int getEsIndexTtl() {
        return esIndexTtl;
    }

    public boolean isEsShipAccessLog() {
        return esShipAccessLog;
    }

}
