package ru.yandex.qloud.kikimr.jobs.qloud;

import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import ru.yandex.qe.auth.api.Group;
import ru.yandex.qe.auth.api.User;

import javax.inject.Inject;
import java.util.List;
import java.util.function.Function;

/**
 * @author violin
 */
@Component
public class MergedAuthApiClientService {
    private final static Logger LOG = LoggerFactory.getLogger(MergedAuthApiClientService.class);

    @Inject
    private List<TypedAuthApiClientService> authServices;

    public List<User> listAllUsers() {
        return list(TypedAuthApiClientService::listAllUsers);
    }

    public List<Group> listAllGroups() {
        return list(TypedAuthApiClientService::listAllGroups);
    }

    private <R> List<R> list(Function<TypedAuthApiClientService, List<R>> apiCall) {
        final ImmutableList.Builder<R> resultBuilder = ImmutableList.builder();
        for (TypedAuthApiClientService authService : authServices) {
            try {
                resultBuilder.addAll(apiCall.apply(authService));
            } catch (Exception e) {
                if (authService.getAuthApiType() == TypedAuthApiClientService.AuthApiType.TESTING) {
                    LOG.warn("couldn't get result from auth testing", e);
                } else {
                    throw e;
                }
            }
        }
        return resultBuilder.build();
    }
}
