package ru.yandex.qloud.kikimr.jobs.qloud;

import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.inject.Inject;
import java.util.List;

/**
 * @author violin
 */
@Component
public class MergedQloudApiClientService {
    private final static Logger LOG = LoggerFactory.getLogger(MergedQloudApiClientService.class);

    @Inject
    private List<TypedQloudApiClientService> qloudServices;

    public List<LoggerSettings> getLoggerSettings() {
        final ImmutableList.Builder<LoggerSettings> settingsBuilder = ImmutableList.builder();
        for (TypedQloudApiClientService qloudApiClientService : qloudServices) {
            try {
                settingsBuilder.addAll(qloudApiClientService.getLoggerSettings());
            } catch (Exception e) {
                if (qloudApiClientService.getQloudApiType() == TypedQloudApiClientService.QloudApiType.TESTING) {
                    LOG.warn("couldn't get log properties from qloud testing", e);
                } else {
                    throw e;
                }
            }
        }
        return settingsBuilder.build();
    }
}
