package ru.yandex.qloud.kikimr.jobs.qloud;

import ru.yandex.qe.auth.api.AuthService;
import ru.yandex.qe.auth.api.AuthSubject;
import ru.yandex.qe.auth.api.Group;
import ru.yandex.qe.auth.api.User;
import ru.yandex.qe.bus.Robot;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * @author violin
 */
public class TypedAuthApiClientService implements AuthService {

    public static enum AuthApiType {
        TESTING, PRESTABLE, STABLE
    }

    private final AuthService delegate;
    private final AuthApiType authApiType;
    private final Robot robot;

    public TypedAuthApiClientService(AuthService delegate, AuthApiType authApiType, String robotToken) {
        this.delegate = delegate;
        this.authApiType = authApiType;
        this.robot = new Robot(robotToken);
    }

    public AuthApiType getAuthApiType() {
        return authApiType;
    }

    @Nonnull
    @Override
    public User getMySelf(boolean secureSessionRequired) {
        return delegate.getMySelf(secureSessionRequired);
    }

    @Nonnull
    @Override
    public User getUser(String login) {
        return delegate.getUser(login);
    }

    @Nonnull
    @Override
    public User getDismissedUser(String login) {
        return delegate.getDismissedUser(login);
    }

    @Nonnull
    @Override
    public List<User> listUsers() {
        return delegate.listUsers();
    }

    @Nonnull
    @Override
    public List<User> listAllUsers() {
        return delegate.listAllUsers();
    }

    @Nonnull
    @Override
    public List<Group> listAllGroups() {
        return robot.runAuthorized(delegate::listAllGroups);
    }

    @Nonnull
    @Override
    public List<User> searchUsersContainsRole(String role, boolean expendGroups, boolean admin) {
        return delegate.searchUsersContainsRole(role, expendGroups, admin);
    }

    @Nonnull
    @Override
    public List<User> searchUsersInRoles(List<String> roles, boolean expendGroups, boolean admin) {
        return delegate.searchUsersInRoles(roles, expendGroups, admin);
    }

    @Nonnull
    @Override
    public List<AuthSubject> listSubjects(String role, boolean includeParents) {
        return delegate.listSubjects(role, includeParents);
    }
}
