package ru.yandex.qloud.kikimr.jobs.qloud;

import java.util.List;

/**
 * @author violin
 */
public class TypedQloudApiClientService implements QloudApiClientService {
    public static enum QloudApiType {
        TESTING, STABLE, PRESTABLE
    }

    private final QloudApiClientService qloudApiClientServiceDelegate;
    private final QloudApiType qloudApiType;

    public TypedQloudApiClientService(QloudApiClientService qloudApiClientServiceDelegate, QloudApiType qloudApiType) {
        this.qloudApiClientServiceDelegate = qloudApiClientServiceDelegate;
        this.qloudApiType = qloudApiType;
    }

    public QloudApiType getQloudApiType() {
        return qloudApiType;
    }

    @Override
    public List<LoggerSettings> getLoggerSettings() {
        return qloudApiClientServiceDelegate.getLoggerSettings();
    }
}
