package ru.yandex.qloud.kikimr.lucene;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * @author violin
 */
public class PagingParameters {
    public static final int DEFAULT_LIMIT = 50;

    public enum PagingDirection {
        NEXT, PREV
    }

    private final long timestamp;
    private final String qloudInstance;
    private final long pushClientId;

    private final long limit = DEFAULT_LIMIT;

    private final PagingParameters.PagingDirection pagingDirection;

    public PagingParameters(long timestamp, String qloudInstance, long pushClientId, PagingParameters.PagingDirection pagingDirection) {
        this.timestamp = timestamp;
        this.qloudInstance = qloudInstance;
        this.pushClientId = pushClientId;
        this.pagingDirection = pagingDirection;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public String getQloudInstance() {
        return qloudInstance;
    }

    public long getPushClientId() {
        return pushClientId;
    }

    public PagingDirection getPagingDirection() {
        return pagingDirection;
    }

    public long getLimit() {
        return limit;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
