package ru.yandex.qloud.kikimr.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import ru.yandex.qloud.kikimr.utils.Sanitizer;

import java.util.Map;

public class SchemaAwareAnalyzer extends DelegatingAnalyzerWrapper {
    private final Map<String, SchemaFieldType> schema;

    SchemaAwareAnalyzer(Map<String, SchemaFieldType> schema) {
        super(Analyzer.GLOBAL_REUSE_STRATEGY);
        this.schema = schema;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        String cleanName = Sanitizer.sanitizeFieldName(fieldName);
        SchemaFieldType type = schema.getOrDefault(cleanName, SchemaFieldType.UTF8);
        return (type == SchemaFieldType.UTF8) ? new KeywordAnalyzer() : new NopAnalyzer();
    }
}
