package ru.yandex.qloud.kikimr.lucene;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * @author violin
 */
public class SchemaProvider {

    private static final Map<String, SchemaFieldType> DEFAULT_SCHEMA = ImmutableMap.<String, SchemaFieldType>builder()
            .put("timestamp", SchemaFieldType.INT64)
            .put("qloud_instance", SchemaFieldType.UTF8)
            .put("pushclient_row_id", SchemaFieldType.INT64)
            .put("topic_part", SchemaFieldType.UTF8)
            .put("offset", SchemaFieldType.INT64)
            .put("timestamp_raw", SchemaFieldType.UTF8)
            .put("version", SchemaFieldType.INT64)
            .put("level", SchemaFieldType.INT64)
            .put("levelStr", SchemaFieldType.UTF8)
            .put("message", SchemaFieldType.UTF8)
            .put("fields", SchemaFieldType.UTF8)
            .put("rest", SchemaFieldType.UTF8)
            .put("qloud_component", SchemaFieldType.UTF8)
            .put("loggerName", SchemaFieldType.UTF8)
            .put("host", SchemaFieldType.UTF8)
            .put("iso_eventtime", SchemaFieldType.UTF8)
            .put("provider", SchemaFieldType.UTF8)
            .put("threadName", SchemaFieldType.UTF8)
            .put("stacktrace", SchemaFieldType.UTF8)
            .put("ts", SchemaFieldType.UTF8)
            .put("datetime", SchemaFieldType.UTF8)
            .put("vhost", SchemaFieldType.UTF8)
            .put("request", SchemaFieldType.UTF8)
            .put("cookies", SchemaFieldType.UTF8)
            .put("ip", SchemaFieldType.UTF8)
            .put("referer", SchemaFieldType.UTF8)
            .put("user_agent", SchemaFieldType.UTF8)
            .put("status", SchemaFieldType.INT32)
            .put("request_id", SchemaFieldType.UTF8)
            .put("nginx_request_length", SchemaFieldType.INT64)
            .put("nginx_bytes_sent", SchemaFieldType.INT64)
            .put("nginx_upstream_addr", SchemaFieldType.UTF8)
            .put("nginx_upstream_response_time", SchemaFieldType.FLOAT)
            .put("nginx_request_time", SchemaFieldType.FLOAT)
            .put("nginx_scheme", SchemaFieldType.UTF8)
            .put("nginx_request_method", SchemaFieldType.UTF8)
            .put("nginx_remote_addr", SchemaFieldType.UTF8)
            .put("qloud_router_instance_name", SchemaFieldType.UTF8)
            .put("qloud_router_name", SchemaFieldType.UTF8)
            .put("balancer_type", SchemaFieldType.UTF8)
            .build();

    public static Map<String, SchemaFieldType> getDefaultSchema() {
        return DEFAULT_SCHEMA;
    }
}
