package ru.yandex.qloud.kikimr.lucene;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import javax.annotation.Nullable;

/**
 * @author violin
 */
public class TimeRangeFilter {

    private final Long timestampFrom;

    private final Long timestampTo;

    public TimeRangeFilter(Long timestampFrom, Long timestampTo) {
        this.timestampFrom = timestampFrom;
        this.timestampTo = timestampTo;
    }

    @Nullable
    public Long getTimestampFrom() {
        return timestampFrom;
    }

    @Nullable
    public Long getTimestampTo() {
        return timestampTo;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
