package ru.yandex.qloud.kikimr.search;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import ru.yandex.qloud.kikimr.lucene.PagingParameters;
import ru.yandex.qloud.kikimr.lucene.TimeRangeFilter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

public class KikimrQueryRequest {

    @Nonnull
    private final QueryWhereCondition queryWhereCondition;
    @Nullable
    private final PagingParameters pagingParameters;
    @Nonnull
    private final TimeRangeFilter timeRangeFilter;

    @Nonnull
    private final List<String> tables;
    @Nonnull
    private final List<String> kikimrQueries;

    protected KikimrQueryRequest(
            @Nonnull QueryWhereCondition queryWhereCondition,
            @Nullable PagingParameters pagingParameters,
            @Nonnull TimeRangeFilter timeRangeFilter,
            @Nonnull List<String> tables,
            @Nonnull List<String> kikimrQueries
    ) {
        this.queryWhereCondition = queryWhereCondition;
        this.pagingParameters = pagingParameters;
        this.timeRangeFilter = timeRangeFilter;
        this.tables = tables;
        this.kikimrQueries = kikimrQueries;
    }

    @Nonnull
    public QueryWhereCondition getQueryWhereCondition() {
        return queryWhereCondition;
    }

    @Nullable
    public PagingParameters getPagingParameters() {
        return pagingParameters;
    }

    @Nonnull
    public TimeRangeFilter getTimeRangeFilter() {
        return timeRangeFilter;
    }

    @Nonnull
    public List<String> getTables() {
        return tables;
    }

    @Nonnull
    public List<String> getKikimrQueries() {
        return kikimrQueries;
    }

    public int getMaxResultsCount() {
        return (int) (pagingParameters != null ? pagingParameters.getLimit() : PagingParameters.DEFAULT_LIMIT);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
