package ru.yandex.qloud.kikimr.services;

import org.springframework.stereotype.Service;
import ru.yandex.qloud.kikimr.jobs.DropTablesByTTLJob;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author violin
 */
@Service("adminService")
@Consumes(MediaType.WILDCARD)
@Produces(MediaType.APPLICATION_JSON)
@Path("/admin/")
public class AdminService {

    private final ExecutorService dropTablesByTTlExecutor = Executors.newSingleThreadExecutor();

    @Inject
    private DropTablesByTTLJob dropTablesByTTLJob;

    @DELETE
    @Path("/drop/by/ttl")
    public void dropTablesByTTL() {
        dropTablesByTTlExecutor.execute(() -> dropTablesByTTLJob.dropTablesByTTL());
    }
}
