package ru.yandex.qloud.kikimr.services;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import ru.yandex.qloud.kikimr.transport.KikimrRpc;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import static com.google.common.base.MoreObjects.firstNonNull;

/**
 * @author violin
 */
@Service("kikimrUtilService")
@Consumes(MediaType.WILDCARD)
@Produces(MediaType.TEXT_PLAIN)
@Path("/kikimr")
public class KikimrUtilService {

    @Inject
    private KikimrRpc kikimrRpc;

    @GET
    @Path("/whoami")
    public String kikimrWhoAmi() {
        return firstNonNull(kikimrRpc.whoami(), "Anonymous user");
    }

    @GET
    @Path("/whoami/test")
    public String testKikimrWhoAmi(@QueryParam("host") String kikimrHost, @QueryParam("port") Integer kikimrPort) {
        if (StringUtils.isBlank(kikimrHost)) {
            throw new IllegalArgumentException("kikimr host is blank");
        }
        KikimrRpc rpc = new KikimrRpc(kikimrHost, firstNonNull(kikimrPort, 2135), 1000L, "");
        try {
            return firstNonNull(rpc.whoami(), "Anonymous user");
        } finally {
            rpc.shutdown();
        }
    }
}
