package ru.yandex.qloud.kikimr.services;

import org.apache.commons.lang3.StringUtils;

import static ru.yandex.qloud.kikimr.services.ParameterNames.Q_APPLICATION_PARAM;
import static ru.yandex.qloud.kikimr.services.ParameterNames.Q_ENVIRONMENT_PARAM;
import static ru.yandex.qloud.kikimr.services.ParameterNames.Q_PROJECT_PARAM;
import static ru.yandex.qloud.kikimr.utils.Sanitizer.sanitizeTablePath;

/**
 * @author violin
 */
public class ParameterUtils {

    public static void validateTableParameters(String project, String application, String environment, String date) {
        validateNotEmpty(sanitizeTablePath(project), Q_PROJECT_PARAM);
        validateNotEmpty(sanitizeTablePath(application), Q_APPLICATION_PARAM);
        validateNotEmpty(sanitizeTablePath(environment), Q_ENVIRONMENT_PARAM);
    }

    private static void validateNotEmpty(String value, String paramName) {
        if (StringUtils.isBlank(value)) {
            throw new IllegalArgumentException(String.format("%s parameter should not be empty", paramName));
        }
    }
    
}
