package ru.yandex.qloud.kikimr.transport;

import com.google.protobuf.ByteString;
import ru.yandex.kikimr.proto.Kqp;

public class KQPException extends KikimrException {
    public KQPException(ByteString kqpError) {
        super(kqpError.toStringUtf8());
    }

    public KQPException(Kqp.EStatus kqpStatus) {
        super(String.format("KQP status not SUCCESS but %s", kqpStatus));
    }
}
