package ru.yandex.qloud.kikimr.transport;

import ru.yandex.qloud.kikimr.utils.EnumUtils;

import javax.annotation.Nonnull;

import static com.google.common.base.MoreObjects.firstNonNull;

/**
 * @author violin
 */
public enum ProxyResultStatus {

    UNKNOWN(0),
    WRONG_REQUEST(1),
    EMPTY_AFFECTED_SET(2),
    NOT_IMPLEMENTED(3),
    RESOLVE_ERROR(4),
    ACCESS_DENIED(5),
    PROXY_NOT_READY(16),
    PROXY_ACCEPTED(17),
    PROXY_RESOLVED(18),
    PROXY_PREPARED(19),
    PROXY_SHARD_NOT_AVAILABLE(20),
    PROXY_SHARD_TRY_LATER(21),
    PROXY_SHARD_OVERLOADED(22),
    PROXY_SHARD_UNKNOWN(23),
    COORDINATOR_DECLINED(32),
    COORDINATOR_OUTDATED(33),
    COORDINATOR_ABORTED(34),
    COORDINATOR_PLANNED(35),
    COORDINATOR_UNKNOWN(36),
    EXEC_COMPLETE(48),
    EXEC_ALREADY(49),
    EXEC_ABORTED(50),
    EXEC_TIMEOUT(51),
    EXEC_ERROR(52),
    EXEC_IN_PROGRESS(53),
    SYNTH_BACKEND_ERROR(64),
    SYNTH_NO_PROXY(65),
    BACKUP_TX_ID_NOT_EXISTS(80),
    TX_ID_IS_NOT_A_BACKUP(81);

    private final int status;

    ProxyResultStatus(int status) {
        this.status = status;
    }

    @Nonnull
    public static ProxyResultStatus byIntStatus(int status) {
        return firstNonNull(EnumUtils.getByValue(ProxyResultStatus.class, status, ProxyResultStatus::getStatus), UNKNOWN);
    }

    public int getStatus() {
        return status;
    }
}
