package ru.yandex.qloud.kikimr.transport;

import ru.yandex.qloud.kikimr.utils.EnumUtils;

import javax.annotation.Nonnull;

import static com.google.common.base.MoreObjects.firstNonNull;

/**
 * @author violin
 */
public enum ResponseStatus {

    MSTATUS_UNKNOWN(0),
    MSTATUS_OK(1),
    MSTATUS_ERROR(128),
    MSTATUS_INPROGRESS(129),
    MSTATUS_TIMEOUT(130),
    MSTATUS_NOTREADY(131),
    MSTATUS_ABORTED(132),
    MSTATUS_INTERNALERROR(133),
    MSTATUS_REJECTED(134);

    private final int status;

    ResponseStatus(int status) {
        this.status = status;
    }

    @Nonnull
    public static ResponseStatus byIntStatus(int status) {
        return firstNonNull(EnumUtils.getByValue(ResponseStatus.class, status, ResponseStatus::getStatus), MSTATUS_UNKNOWN);
    }

    public int getStatus() {
        return status;
    }
}
