package ru.yandex.qloud.kikimr.transport;

import com.google.common.base.Joiner;
import com.google.protobuf.UnknownFieldSet;
import com.yandex.ydb.YdbIssueMessage;

import java.util.List;
import java.util.stream.Collectors;

public class YQLException extends RuntimeException {
    public YQLException(List<YdbIssueMessage.IssueMessage> queryErrors) {
        super(convert(queryErrors));
    }

    private static String convert(List<YdbIssueMessage.IssueMessage> queryErrors) {
        return Joiner.on("\n").join(
                queryErrors.stream()
                        .map((error) -> {
                            StringBuilder sb = new StringBuilder(error.getMessage());
                            sb.append("\n").append(convert(error.getIssuesList()));
                            if (error.getUnknownFields().isInitialized()) {
                                for (UnknownFieldSet.Field field : error.getUnknownFields().asMap().values()) {
                                    field.getLengthDelimitedList().forEach((bytes) -> sb.append("\n").append(bytes.toStringUtf8()));
                                }
                            }
                            return sb.toString();
                        })
                        .collect(Collectors.toList())
        );
    }
}
