package ru.yandex.qloud.kikimr.transport.acl;

/**
 * @author violin
 */
//https://a.yandex-team.ru/arc/trunk/arcadia/kikimr/library/aclib/aclib.h
public enum EAccessRights {
    SELECT_ROW(0x00000001),
    UPDATE_ROW(0x00000002),
    ERASE_ROW(0x00000004),
    READ_ATTRIBUTES(0x00000008),
    WRITE_ATTRIBUTES(0x00000010),
    CREATE_DIRECTORY(0x00000020),
    CREATE_TABLE(0x00000040),
    CREATE_QUEUE(0x00000080),
    REMOVE_SCHEMA(0x00000100),
    DESCRIBE_SCHEMA(0x00000200),
    ALTER_SCHEMA(0x00000400),
    CREATE_DATABASE(0x00000800),
    DROP_DATABASE(0x00001000),
    GRANT_ACCESS_RIGHTS(0x00002000),
    WRITE_USER_ATTRIBUTES(0x00004000),

    GENERIC_READ(SELECT_ROW.getValue() | READ_ATTRIBUTES.getValue() | DESCRIBE_SCHEMA.getValue()),
    GENERIC_WRITE(UPDATE_ROW.getValue() | ERASE_ROW.getValue() | WRITE_ATTRIBUTES.getValue() | CREATE_DIRECTORY.getValue() | CREATE_TABLE.getValue() | CREATE_QUEUE.getValue() | REMOVE_SCHEMA.getValue() | ALTER_SCHEMA.getValue() | WRITE_USER_ATTRIBUTES.getValue()),
    GENERIC_USE(GENERIC_READ.getValue() | GENERIC_WRITE.getValue() | GRANT_ACCESS_RIGHTS.getValue()),
    GENERIC_MANAGE(CREATE_DATABASE.getValue() | DROP_DATABASE.getValue()),
    GENERIC_FULL(GENERIC_USE.getValue() | GENERIC_MANAGE.getValue());

    private final int value;

    EAccessRights(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }
}
