package ru.yandex.qloud.kikimr.utils;

import javax.annotation.Nullable;
import java.util.function.Function;

/**
 * @author violin
 */
public class EnumUtils {

    @Nullable
    public static <E extends Enum<E>, V> E getByValue(Class<E> enumClass, V value, Function<E, V> enumValueFunction) {
        for (E enumValue : enumClass.getEnumConstants()) {
            if (enumValueFunction.apply(enumValue).equals(value)) {
                return enumValue;
            }
        }
        return null;
    }
}
