package ru.yandex.qloud.kikimr.utils;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Sanitizer {
    public static String sanitizeTablePath(String value) {
        return value;
    }

    public static String sanitizeFieldName(String field) {
        String sanitized = StringEscapeUtils.escapeSql(field.replaceAll("@", ""));
        if (sanitized.contains(".")) {
            String baseField = StringUtils.substringBefore(sanitized, ".");
            String jsonPath = StringUtils.substringAfter(sanitized, ".").replaceAll("\\.", "/");
            sanitized = String.format("Json::GetField(%s, '%s'){0}", baseField, jsonPath);
        }
        return sanitized;
    }

    public static String sanitizeTextValue(String value) {
        if (value == null) {
            return null;
        }
        return StringUtils.replace(value, "'", "\\'");
    }
}
