package ru.yandex.qloud.kikimr.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.LocalDate;

import static ru.yandex.qloud.kikimr.utils.Sanitizer.sanitizeTablePath;

/**
 * @author violin
 */
public class TableUtils {
    private final static Logger LOG = LoggerFactory.getLogger(TableUtils.class);

    private static final String ACCESS_PREFIX = "access-";

    public static String toKikimrTable(
            @Nonnull String project,
            @Nonnull String application,
            @Nonnull String environment,
            @Nonnull String date,
            boolean access
    ) {
        return String.format(
                "/Root/qloud/%s/%s/%s/%s",
                sanitizeTablePath(project),
                sanitizeTablePath(application),
                sanitizeTablePath(environment),
                tableName(date, access)
        );
    }

    public static String toKikimrTable(String pathToTable, String date, boolean access) {
        return pathToTable + "/" + tableName(date, access);
    }

    public static String toKikimrNode(
            @Nonnull String project,
            @Nonnull String application,
            @Nonnull String environment
    ) {
        return String.format(
                "/Root/qloud/%s/%s/%s",
                sanitizeTablePath(project),
                sanitizeTablePath(application),
                sanitizeTablePath(environment)
        );
    }

    @Nullable
    public static LocalDate parseDateFromTableName(String kikimrTable) {
        try {
            String dateFromTable = unparsedDateFromTableName(kikimrTable.substring(kikimrTable.lastIndexOf("/") + 1));
            return LocalDate.parse(dateFromTable);
        } catch (Exception e) {
            LOG.warn(String.format("exception by parsing date from table %s", kikimrTable), e);
            return null;
        }
    }

    public static String unparsedDateFromTableName(String simpleTableName) {
        return StringUtils.replace(simpleTableName, ACCESS_PREFIX, "");
    }

    private static String tableName(String date, boolean access) {
        return (access ? ACCESS_PREFIX : "") + sanitizeTablePath(date);
    }
}
