package ru.yandex.qloud.kikimr.tool;

import NACLibProto.Aclib;
import NKikimrClient.TGRpcServerGrpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import ru.yandex.kikimr.proto.FlatSchemeOp;
import ru.yandex.kikimr.proto.Msgbus;
import ru.yandex.kikimr.proto.TxProxy;
import ru.yandex.qloud.kikimr.transport.ProxyResultStatus;
import ru.yandex.qloud.kikimr.transport.ResponseStatus;
import ru.yandex.qloud.kikimr.transport.acl.EAccessRights;
import ru.yandex.qloud.kikimr.transport.acl.EAccessType;
import ru.yandex.qloud.kikimr.transport.acl.EDiffType;
import ru.yandex.qloud.kikimr.transport.acl.EInheritanceType;

/**
 * @author violin
 */
public class ModifyAclTool {
    public static void main(String[] args) {
        ManagedChannel channel = ManagedChannelBuilder
                .forAddress("qloud-kikimr.yandex.net", 2135)
                .usePlaintext()
                .build();

        TGRpcServerGrpc.TGRpcServerBlockingStub rpc = TGRpcServerGrpc.newBlockingStub(channel);

        Aclib.TACE tace1 = Aclib.TACE.newBuilder()
                .setAccessRight(EAccessRights.GENERIC_FULL.getValue())
                .setAccessType(EAccessType.ALLOW.getValue())
                .setInheritanceType(EInheritanceType.INHERIT_OBJECT.getValue() | EInheritanceType.INHERIT_CONTAINER.getValue())
                .setSID("violin@staff")
                .build();
        Aclib.TDiffACE newAce1 = Aclib.TDiffACE.newBuilder().setACE(tace1).setDiffType(EDiffType.ADD.getValue()).build();

        Aclib.TACE tace2 = Aclib.TACE.newBuilder()
                .setAccessRight(EAccessRights.SELECT_ROW.getValue())
                .setAccessType(EAccessType.ALLOW.getValue())
                .setInheritanceType(EInheritanceType.INHERIT_OBJECT.getValue())
                .setSID("intr13@staff")
                .build();
        Aclib.TDiffACE newAce2 = Aclib.TDiffACE.newBuilder().setACE(tace2).setDiffType(EDiffType.ADD.getValue()).build();

        Aclib.TDiffACL acl = Aclib.TDiffACL.newBuilder()
                .addDiffACE(Aclib.TDiffACE.newBuilder().clearACE().setDiffType(EDiffType.CLEAR.getValue()).build())
                .addDiffACE(newAce1)
                .addDiffACE(newAce2)
                .build();

        FlatSchemeOp.TModifyACL tModifyACL = FlatSchemeOp.TModifyACL.newBuilder()
                .setName("2017-10-13")
                .setDiffACL(acl.toByteString()).build();

        FlatSchemeOp.TModifyScheme modifyScheme = FlatSchemeOp.TModifyScheme.newBuilder()
                .setWorkingDir("Root/qloud/junk/violin/test")
                .setOperationType(FlatSchemeOp.EOperationType.ESchemeOpModifyACL)
                .setModifyACL(tModifyACL).build();

        TxProxy.TTransaction transaction = TxProxy.TTransaction.newBuilder()
                .setModifyScheme(modifyScheme).build();

        Msgbus.TSchemeOperation operation = Msgbus.TSchemeOperation.newBuilder()
                .setTransaction(transaction).build();

        Msgbus.TResponse response = rpc.schemeOperation(operation);
        ResponseStatus responseStatus = ResponseStatus.byIntStatus(response.getStatus());
        ProxyResultStatus proxyResultStatus = ProxyResultStatus.byIntStatus(response.getProxyErrorCode());
        System.out.println(responseStatus + " : " + proxyResultStatus + " : " + response);

        Msgbus.TFlatTxId transactionId = response.getFlatTxId();

        Msgbus.TSchemeOperationStatus operationStatus = Msgbus.TSchemeOperationStatus.newBuilder()
                .setFlatTxId(transactionId).build();
        Msgbus.TResponse statusResponse = rpc.schemeOperationStatus(operationStatus);
        ResponseStatus statusResponseStatus = ResponseStatus.byIntStatus(statusResponse.getStatus());
        ProxyResultStatus statusProxyResultStatus = ProxyResultStatus.byIntStatus(statusResponse.getProxyErrorCode());

        System.out.println(statusResponseStatus + " : " + statusProxyResultStatus + " : " + statusResponse);
    }
}
