package ru.yandex.qloud.kikimr.tool;

import ru.yandex.kikimr.proto.FlatSchemeOp;
import ru.yandex.kikimr.proto.Msgbus;
import ru.yandex.qloud.kikimr.transport.KikimrRpc;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author violin
 */
public class SchemeDescribeTool {

    public static void main(String[] args) {
        KikimrRpc kikimrRpc = new KikimrRpc("qloud-kikimr.yandex.net", 2135, 1000, "");

        Msgbus.TSchemeDescribe request = Msgbus.TSchemeDescribe.newBuilder()
                .setPath("Root/qloud")
                .setOptions(FlatSchemeOp.TDescribeOptions.newBuilder().setReturnPartitionConfig(true).setReturnPartitioningInfo(true).build())
                .build();

        Msgbus.TResponse response = kikimrRpc.getRpcWithDeadline().schemeDescribe(request);
        if (response.hasPathDescription()) {
            List<String> tables = response.getPathDescription().getChildrenList().stream().map(FlatSchemeOp.TDirEntry::getName).collect(
                    Collectors.toList());
            System.out.println(tables);
        }
        System.out.println(response);
    }


}
