package ru.yandex.qloud.kikimr.tool;

import com.fasterxml.jackson.core.JsonProcessingException;
import ru.yandex.qe.json.DefaultJsonMapper;
import ru.yandex.qloud.kikimr.lucene.ESResultConverter;
import ru.yandex.qloud.kikimr.transport.KikimrRpc;
import ru.yandex.qloud.kikimr.transport.YQL;

import java.util.List;

/**
 * @author violin
 */
public class YqlQueryTool {

    public static void main(String[] args) throws JsonProcessingException {
        String query = "PRAGMA kikimr.isolationLevel = \"ReadUncommitted\"; SELECT * FROM [/Root/qloud/voice-ext/vins-int/stable/2017-10-16] WHERE TRUE ORDER BY timestamp ASC, qloud_instance ASC, pushclient_row_id ASC LIMIT 50";

        YQL yql = new YQL(new KikimrRpc("qloud-kikimr.yandex.net", 2135, 1000, ""));
        YQL.Result result = yql.query(query);

        List<String> fields = result.getFieldsNames();
        for (YQL.Row row : result.getRows()) {
            Object[] values = row.getData();
            for (int i = 0; i < fields.size(); i++) {
                System.out.println(fields.get(i) + " = " + values[i]);
            }
        }

        ESResultConverter resultConverter = new ESResultConverter();
        ESResultConverter.ESResult esResult = resultConverter.convert(result);
        DefaultJsonMapper mapper = new DefaultJsonMapper();
        System.out.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(esResult));
    }
}
